%{
#include <stdio.h>
#include <string.h>

yyerror(s)
char *s;
{
  fprintf(stderr, "%s\n",s);
}

 
int yywrap()
{
        return 1;
} 
  
main()
{
        yyparse();
} 
%}

%union 
{
        int number;
        char *string;
}

%token IF EQUALS FOR TO DEFINE PRINT PLING

%token <string> NUMBER
%token <string> OPERATOR
%token <string> IDENTIFIER
%token <string> BRACE
%token <string> SQBRACE
%token <string> COMPARITOR

%type <string> arrayorvar



%%
commands: /* empty */
        | commands command
        ;

command:
        assignment
	|
	comparator
	|
	sytantical
	|
	loop
	|
	defin
	|
	maths
	|
	display	
        ;

display:
	PRINT IDENTIFIER
	{
		printf("print\n%s\n",$2);
	}
	;

maths:
	IDENTIFIER OPERATOR OPERATOR
	{
		printf("%s\n%s\n%s\n",$3,$2,$1);
	};

assignment: 
        IDENTIFIER EQUALS IDENTIFIER
        {
                printf(":=\n%s\n%s\n",$1,$3);
        }
	|
	IDENTIFIER EQUALS NUMBER
	{
		printf(":=n\n%s\n%s\n",$1,$3);
	}	
	|
	IDENTIFIER EQUALS NUMBER OPERATOR NUMBER
	{
		printf(":=non\n%s\n%s\n%s\n%s\n",$1,$3,$4,$5);
	}
	|	
	IDENTIFIER EQUALS IDENTIFIER OPERATOR NUMBER
	{
		printf(":=ion\n%s\n%s\n%s\n%s\n",$1,$3,$4,$5);
	}
	|	
	IDENTIFIER EQUALS NUMBER OPERATOR IDENTIFIER
	{
		printf(":=ion\n%s\n%s\n%s\n%s\n",$1,$5,$4,$3);
	}
	|	
	IDENTIFIER EQUALS IDENTIFIER OPERATOR IDENTIFIER
	{
		printf(":=ioi\n%s\n%s\n%s\n%s\n",$1,$3,$4,$5);
	}
	



	|
	IDENTIFIER SQBRACE NUMBER SQBRACE EQUALS IDENTIFIER
	{
		printf(":=\n%s%s\n%s\n",$1,$3,$6);
	}
	|
	IDENTIFIER SQBRACE NUMBER SQBRACE EQUALS NUMBER
	{
		printf(":=n\n%s%s\n%s\n",$1,$3,$6);
	}
	|
	IDENTIFIER SQBRACE NUMBER SQBRACE EQUALS NUMBER OPERATOR NUMBER
	{
		printf(":=non\n%s%s\n%s\n%s\n%s\n",$1,$3,$6,$7,$8);
	}
	|
	IDENTIFIER SQBRACE NUMBER SQBRACE EQUALS IDENTIFIER OPERATOR NUMBER
	{
		printf(":=ion\n%s%s\n%s\n%s\n%s\n",$1,$3,$6,$7,$8);
	}
	|
	IDENTIFIER SQBRACE NUMBER SQBRACE EQUALS NUMBER OPERATOR IDENTIFIER
	{
		printf(":=ion\n%s%s\n%s\n%s\n%s\n",$1,$3,$8,$7,$6);
	}
	|
	IDENTIFIER SQBRACE NUMBER SQBRACE EQUALS IDENTIFIER OPERATOR IDENTIFIER
	{
		printf(":=ioi\n%s%s\n%s\n%s\n%s\n",$1,$3,$6,$7,$8);
	}
        ;
	
comparator:
	IF IDENTIFIER COMPARITOR IDENTIFIER
	{
		printf("if\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|
	IF IDENTIFIER COMPARITOR NUMBER
	{
		printf("ifn\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|		
	IF NUMBER COMPARITOR IDENTIFIER
	{
		printf("ifn\n%s\n%s\n%s\n",$3,$4,$2);
	}
	|
	

	IF IDENTIFIER COMPARITOR array
	{
		printf("if\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|
	IF array COMPARITOR IDENTIFIER
	{
		printf("if\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|

	IF array COMPARITOR array
	{
		printf("if\n%s\n%s\n%s\n",$3,$2,$3);
	}
	|
	IF array COMPARITOR NUMBER
	{
		printf("ifn\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|	
	IF NUMBER COMPARITOR array
	{
		printf("ifn\n%s\n%s%s\n%s\n",$3,$4,$2);
	}			
	;

sytantical:
	BRACE
	{
		printf("%s\n",$1);
	}
	;

loop:
	FOR IDENTIFIER EQUALS NUMBER TO NUMBER
	{
		printf("for\n%s\n=\n%s\nto\n%s\n",$2,$4,$6);
	}
	|
	FOR IDENTIFIER EQUALS NUMBER TO IDENTIFIER
	{
		printf("fori\n%s\n=\n%s\nto\n%s\n",$2,$4,$6);
	}
	;

defin:
	DEFINE IDENTIFIER SQBRACE NUMBER SQBRACE
	{
		printf("def\n%s\n%s\n",$2,$4);
	}
	;

arrayorvar:
	IDENTIFIER
	{
		$$=$1;
	}
	|
	IDENTIFIER SQBRACE NUMBER SQBRACE
	{
		
		$$=strncat($1,$3,(strlen($3)));
	}	
	;
%%


